/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class GameOverMenu
extends GameCanvas
implements Runnable {
    LayerManager lm = new LayerManager();
    Sprite[] icon = new Sprite[4];
    boolean[] directIconEffect = new boolean[4];
    GameDesign gameDesign = new GameDesign();
    private BomMidlet midlet;
    private int countNeedle;
    private int countShield;
    private int countLife;
    private int score;
    private int stage;
    private int time;
    private int sizeMode;
    private Thread gameThread;
    private boolean isPlay = true;
    private long delay = 100L;
    private int dx;
    private int dy;
    private Name[] name = new Name[5];
    private String[] note = new String[2];
    boolean direct = true;
    int colorEffect = 0;
    int cx;
    int cy;
    int iconEffect = 0;
    int maxY;
    int minY;

    public GameOverMenu(BomMidlet midlet, int countNeedle, int countShield, int countLife, int score, int time, int stage, int sizeMode) throws IOException {
        super(false);
        this.setFullScreenMode(true);
        this.midlet = midlet;
        this.countNeedle = countNeedle;
        this.countShield = countShield;
        this.countLife = countLife;
        this.score = score;
        this.sizeMode = sizeMode;
        this.stage = stage;
        this.time = time;
        this.init();
        this.dx = this.icon[0].getX();
        this.dy = this.icon[0].getY() + 3 * this.icon[0].getWidth();
        this.cx = this.dx;
        this.cy = this.dy;
        for (int i = 0; i < 5; ++i) {
            this.name[i] = new Name(i);
        }
    }

    public void init() throws IOException {
        int i;
        if (this.midlet.menuLanguage) {
            this.note[0] = " YOUR SYMBOL ";
            this.note[1] = "Press 5 Or Center Key To Save Score";
        } else {
            this.note[0] = " CH\u1eee K\u00dd  ";
            this.note[1] = "\u1ea4n ph\u00edm 5 ho\u1eb7c ph\u00edm gi\u1eefa \u0111\u1ec3 l\u01b0u \u0111i\u1ec3m ";
        }
        for (i = 0; i < 4; ++i) {
            this.directIconEffect[i] = true;
            this.icon[i] = new Sprite(this.gameDesign.getChar124(), 24, 24);
            this.icon[i].setFrameSequence(this.gameDesign.CHAR124seqLose);
            this.icon[i].setFrame(i);
            this.lm.append((Layer)this.icon[i]);
        }
        if (this.sizeMode == 2) {
            for (i = 0; i < 4; ++i) {
                this.icon[i].setImage(this.gameDesign.getChar118(), 18, 18);
            }
        }
        this.icon[0].setPosition(this.getWidth() / 4, this.getHeight() / 3);
        this.icon[1].setPosition(this.icon[0].getX() + this.icon[0].getWidth(), this.icon[0].getY() + this.icon[0].getHeight() / 2);
        this.icon[2].setPosition(this.icon[1].getX() + this.icon[1].getWidth(), this.icon[0].getY());
        this.icon[3].setPosition(this.icon[2].getX() + this.icon[2].getWidth(), this.icon[0].getY() - this.icon[0].getHeight() / 2);
        this.minY = this.icon[0].getY() - this.icon[0].getHeight();
        this.maxY = this.icon[0].getY() + this.icon[0].getHeight();
    }

    public void iconEffect() {
        for (int i = 0; i < 4; ++i) {
            if (this.directIconEffect[i]) {
                if (this.icon[i].getY() > this.minY) {
                    this.icon[i].move(0, -this.icon[i].getHeight() / 2);
                    continue;
                }
                this.directIconEffect[i] = false;
                continue;
            }
            if (this.icon[i].getY() < this.maxY) {
                this.icon[i].move(0, this.icon[i].getHeight() / 2);
                continue;
            }
            this.directIconEffect[i] = true;
        }
    }

    public void colorEffect(Graphics g) {
        ++this.colorEffect;
        switch (this.colorEffect) {
            case 0: {
                g.setColor(255, 0, 0);
                break;
            }
            case 1: {
                g.setColor(255, 128, 0);
                break;
            }
            case 2: {
                g.setColor(255, 255, 0);
                break;
            }
            case 3: {
                g.setColor(0, 0, 255);
                break;
            }
            case 4: {
                g.setColor(0, 255, 255);
                break;
            }
            case 5: {
                g.setColor(128, 128, 0);
                break;
            }
            case 6: {
                g.setColor(64, 0, 64);
            }
        }
        if (this.colorEffect == 7) {
            this.colorEffect = 0;
        }
        if (this.colorEffect % 2 == 0) {
            for (int i = 0; i < 4; ++i) {
                this.icon[i].nextFrame();
            }
        }
    }

    public void drawScreen(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.lm.paint(g, 0, 0);
        g.setColor(255, 0, 0);
        Font font = Font.getFont((int)64, (int)1, (int)16);
        g.setFont(font);
        this.colorEffect(g);
        for (int i = 0; i < 5; ++i) {
            g.drawString(this.name[i].cha[this.name[i].chaPositon], this.dx + i * this.icon[0].getWidth(), this.dy, 20);
        }
        g.drawString(this.note[0], this.dx, this.dy - this.icon[0].getHeight(), 20);
        g.setFont(Font.getFont((int)64, (int)4, (int)8));
        g.setColor(0, 255, 0);
        g.drawString(this.note[1], this.getWidth() / 2, this.dy + this.icon[0].getHeight(), 17);
        g.setColor(255, 255, 255);
        g.drawRect(this.cx - this.icon[0].getWidth() / 5, this.cy, font.getSize(), font.getHeight());
        this.flushGraphics();
    }

    protected void keyPressed(int keyCode) {
        try {
            super.keyPressed(keyCode);
            if (this.isPlay) {
                int gameAction = this.getGameAction(keyCode);
                switch (gameAction) {
                    case 5: {
                        if (this.cx < this.dx + 4 * this.icon[0].getWidth()) {
                            this.cx += this.icon[0].getWidth();
                            break;
                        }
                        this.cx = this.icon[0].getX();
                        break;
                    }
                    case 2: {
                        if (this.cx > this.icon[0].getX()) {
                            this.cx -= this.icon[0].getWidth();
                            break;
                        }
                        this.cx = this.dx + 4 * this.icon[0].getWidth();
                        break;
                    }
                    case 1: {
                        int position = (this.cx - this.icon[0].getX()) / this.icon[0].getWidth();
                        if (this.name[position].chaPositon < this.name[position].cha.length - 1) {
                            ++this.name[position].chaPositon;
                            break;
                        }
                        this.name[position].chaPositon = 0;
                        break;
                    }
                    case 6: {
                        int posi = (this.cx - this.icon[0].getX()) / this.icon[0].getWidth();
                        if (this.name[posi].chaPositon > 0) {
                            --this.name[posi].chaPositon;
                            break;
                        }
                        this.name[posi].chaPositon = this.name[posi].cha.length - 1;
                        break;
                    }
                    case 8: {
                        String str = "";
                        for (int i = 0; i < 5; ++i) {
                            str = str + this.name[i].cha[this.name[i].chaPositon];
                        }
                        Score scoreData = new Score("BOOM");
                        scoreData.loadScores();
                        scoreData.saveStage(this.stage - 1, this.score, this.time, this.countLife, this.countNeedle, this.countShield);
                        if (scoreData.isHighScore(this.stage, this.time)) {
                            scoreData.updateScores(this.stage, this.time, str);
                        }
                        str = null;
                        scoreData = null;
                        this.clean();
                        Thread.sleep(3000L);
                        this.midlet.display.setCurrent((Displayable)new SunnetCanvas(this.midlet));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void clean() {
        this.lm = null;
        this.icon = null;
        this.gameDesign = null;
        this.gameThread = null;
        this.name = null;
        this.note = null;
        this.directIconEffect = null;
        Runtime.getRuntime().gc();
    }

    public void start() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Graphics g = this.getGraphics();
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long timeTake;
                if (currentThread != this.gameThread) {
                    g = null;
                    currentThread = null;
                    Runtime.getRuntime().gc();
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (this.isShown() && this.isPlay) {
                    this.iconEffect();
                    this.drawScreen(g);
                    Runtime.getRuntime().gc();
                }
                if ((timeTake = System.currentTimeMillis() - startTime) < this.delay) {
                    GameOverMenu gameOverMenu = this;
                    synchronized (gameOverMenu) {
                        this.wait(this.delay - timeTake);
                        continue;
                    }
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class Name {
        int position;
        String[] cha = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        int chaPositon = 0;

        public Name(int position) {
            this.position = position;
        }
    }
}

