/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class HelpScreen
extends GameCanvas
implements CommandListener,
Runnable {
    private boolean isPlay = true;
    private long delay = 75L;
    private Thread gameThread = null;
    SunnetCanvas sunnetCanvas;
    GameDesign gameDesign = new GameDesign();
    Sprite[] player;
    Sprite[] enemy;
    Sprite[] item;
    Sprite shield;
    Sprite[] bom;
    Sprite[] doubleBom;
    String[] note;
    LayerManager lm = new LayerManager();
    int time = 0;
    int timeBom = 0;
    int timeDestroy = 0;
    private int bomLength = 1;
    Command backCommand = new Command("Back", 2, 1);
    boolean isCommand = false;
    Font font = Font.getFont((int)64, (int)1, (int)0);
    boolean readyBom = false;
    boolean destroyBom = false;
    int nextBom = 0;

    public HelpScreen(SunnetCanvas sunnetCanvas) throws Exception {
        super(false);
        this.sunnetCanvas = sunnetCanvas;
        this.init();
        this.addCommand(this.backCommand);
        this.setCommandListener(this);
    }

    private void init() throws IOException {
        this.note = new String[13];
        if (this.sunnetCanvas.midlet.menuLanguage) {
            this.note[0] = "PLAYER";
            this.note[1] = "ENEMY";
            this.note[2] = "ITEM";
            this.note[3] = "NEEDLE";
            this.note[4] = "SHIELD";
            this.note[5] = "TURTLE";
            this.note[6] = "HASTE";
            this.note[7] = "BOM+++";
            this.note[8] = "SBOM  ";
            this.note[9] = "LIFE+ ";
            this.note[10] = "???   ";
            this.note[11] = "GOLD  ";
            this.note[12] = "LIFE UP";
        } else {
            this.note[0] = "NGU\u1edcI CH\u01a0I";
            this.note[1] = "K\u1eba TH\u00d9";
            this.note[2] = "ITEM";
            this.note[3] = "KIM   ";
            this.note[4] = "KHI\u00caN ";
            this.note[5] = "R\u00d9A   ";
            this.note[6] = "T\u0102NG T\u1ed0C";
            this.note[7] = "BOM+++";
            this.note[8] = "BOM M\u1ea0NH  ";
            this.note[9] = "M\u1ea0NG+ ";
            this.note[10] = "???   ";
            this.note[11] = "V\u00c0NG  ";
            this.note[12] = "T\u0102NG M\u1ea0NG";
        }
        this.initPlayer();
        this.initenemy();
        this.initItem();
        this.initBom();
        Runtime.getRuntime().gc();
    }

    private void action() throws IOException {
        ++this.time;
        if (this.time == 120) {
            this.time = 0;
        }
        this.playerAction();
        this.enemyAction();
        this.itemAction();
        this.bomAction();
    }

    private void initPlayer() throws IOException {
        int i;
        this.player = new Sprite[11];
        for (i = 0; i < this.player.length; ++i) {
            this.player[i] = new Sprite(this.gameDesign.getChar124(), 24, 24);
            if (this.sunnetCanvas.sizeMode == 2) {
                this.player[i].setImage(this.gameDesign.getChar118(), 18, 18);
            }
            this.lm.append((Layer)this.player[i]);
        }
        for (i = 0; i < 6; ++i) {
            this.player[i].setPosition(50 + i * this.player[i].getWidth(), 0);
        }
        this.player[0].setFrameSequence(this.gameDesign.CHAR124seqRight);
        this.player[1].setFrameSequence(this.gameDesign.CHAR124seqDown);
        this.player[2].setFrameSequence(this.gameDesign.CHAR124seqLeft);
        this.player[3].setFrameSequence(this.gameDesign.CHAR124seqUp);
        this.player[4].setFrameSequence(this.gameDesign.CHAR124seqWin);
        this.player[5].setFrameSequence(this.gameDesign.CHAR124seqLose);
    }

    private void playerAction() {
        for (int i = 0; i < 4; ++i) {
            this.player[i].nextFrame();
        }
        if (this.time % 5 == 0) {
            this.player[4].nextFrame();
            this.player[5].nextFrame();
        }
    }

    private void initenemy() throws IOException {
        int i;
        this.enemy = new Sprite[6];
        for (i = 0; i < 3; ++i) {
            this.enemy[i] = new Sprite(this.gameDesign.getChar224(), 24, 24);
            if (this.sunnetCanvas.sizeMode == 2) {
                this.enemy[i].setImage(this.gameDesign.getChar218(), 18, 18);
            }
            this.lm.append((Layer)this.enemy[i]);
        }
        for (i = 3; i < 6; ++i) {
            this.enemy[i] = new Sprite(this.gameDesign.getSnake24(), 24, 24);
            if (this.sunnetCanvas.sizeMode == 2) {
                this.enemy[i].setImage(this.gameDesign.getSnake18(), 18, 18);
            }
            this.lm.append((Layer)this.enemy[i]);
        }
        this.enemy[0].setFrameSequence(this.gameDesign.CHAR224seqRight);
        this.enemy[1].setFrameSequence(this.gameDesign.CHAR224seqLeft);
        this.enemy[2].setFrameSequence(this.gameDesign.CHAR224seqLose);
        this.enemy[3].setFrameSequence(this.gameDesign.SNAKE24seqRight);
        this.enemy[4].setFrameSequence(this.gameDesign.SNAKE24seqLeft);
        this.enemy[5].setFrameSequence(this.gameDesign.SNAKE24seqLose);
        for (i = 0; i < 6; ++i) {
            this.enemy[i].setPosition(this.player[i].getX(), this.player[i].getY() + this.player[i].getHeight());
        }
    }

    private void enemyAction() {
        for (int i = 0; i < this.enemy.length; ++i) {
            if (i == 2 || i == 5) continue;
            this.enemy[i].nextFrame();
        }
        if (this.time % 5 == 0) {
            this.enemy[2].nextFrame();
            this.enemy[5].nextFrame();
        }
    }

    private void initItem() throws IOException {
        int i;
        this.shield = new Sprite(this.gameDesign.getShield30(), 30, 30);
        if (this.sunnetCanvas.sizeMode == 2) {
            this.shield.setImage(this.gameDesign.getShield24(), 24, 24);
        }
        this.lm.append((Layer)this.shield);
        this.item = new Sprite[10];
        for (i = 0; i < 8; ++i) {
            this.item[i] = new Sprite(this.gameDesign.getItem24(), 20, 24);
            if (this.sunnetCanvas.sizeMode == 2) {
                this.item[i].setImage(this.gameDesign.getItem18(), 14, 18);
            }
            this.item[i].setPosition(this.player[0].getX() + 20, 10 + this.player[0].getY() + 2 * this.player[0].getWidth() + i * this.item[i].getWidth());
            this.lm.append((Layer)this.item[i]);
        }
        this.item[8] = new Sprite(this.gameDesign.getMoney(), 20, 20);
        this.item[9] = new Sprite(this.gameDesign.getMoney(), 20, 20);
        this.item[8].setPosition(this.item[0].getX(), this.item[7].getY() + this.item[7].getHeight());
        this.item[9].setPosition(this.item[8].getX() + this.item[9].getWidth(), this.item[8].getY());
        this.item[0].setFrameSequence(this.gameDesign.NEEDLE);
        this.item[1].setFrameSequence(this.gameDesign.SHIELD);
        this.item[2].setFrameSequence(this.gameDesign.TURTLE);
        this.item[3].setFrameSequence(this.gameDesign.HASTESHOES);
        this.item[4].setFrameSequence(this.gameDesign.DOUBLEBOM);
        this.item[5].setFrameSequence(this.gameDesign.SUPERBOM);
        this.item[6].setFrameSequence(this.gameDesign.LIFE);
        this.item[7].setFrameSequence(this.gameDesign.BOOM);
        this.item[8].setFrameSequence(this.gameDesign.MONEYseq001);
        this.item[9].setFrameSequence(this.gameDesign.MONEYseq002);
        this.player[6].setFrameSequence(this.gameDesign.CHAR124seqRight);
        this.player[6].setPosition(this.item[1].getX() + 2 * this.player[6].getWidth(), this.item[1].getY());
        this.shield.setPosition(this.player[6].getX() - 3, this.player[6].getY() - 5);
        this.player[7].setFrameSequence(this.gameDesign.CHAR124seqLose);
        this.player[7].setPosition(this.item[0].getX() + 2 * this.player[7].getWidth(), this.item[0].getY());
        this.player[8].setFrameSequence(this.gameDesign.CHAR124seqRight);
        this.player[8].setPosition(this.item[3].getX() + 2 * this.player[8].getWidth(), this.item[3].getY());
        this.player[9].setFrameSequence(this.gameDesign.CHAR124seqRight);
        this.player[9].setPosition(this.item[2].getX() + 2 * this.player[9].getWidth(), this.item[2].getY() - 5);
        this.player[10].setFrameSequence(this.gameDesign.HORSE124Right);
        this.player[10].setPosition(this.player[9].getX(), this.player[9].getY() + 10);
        this.lm.append((Layer)this.item[8]);
        this.lm.append((Layer)this.item[9]);
        this.bom = new Sprite[10];
        for (i = 0; i < 10; ++i) {
            this.bom[i] = new Sprite(this.gameDesign.getBom24(), 24, 24);
            if (this.sunnetCanvas.sizeMode == 2) {
                this.bom[i].setImage(this.gameDesign.getBom18(), 18, 18);
            }
            this.bom[i].setVisible(false);
            this.lm.append((Layer)this.bom[i]);
        }
        this.bom[this.bomLength * 4 + 1] = new Sprite(this.gameDesign.getBom20(), 20, 20);
        this.lm.append((Layer)this.bom[this.bomLength * 4 + 1]);
        this.doubleBom = new Sprite[4];
        for (i = 0; i < 4; ++i) {
            this.doubleBom[i] = new Sprite(this.gameDesign.getBom20(), 20, 20);
            if (this.sunnetCanvas.sizeMode == 2) {
                this.doubleBom[i].setImage(this.gameDesign.getBom16(), 16, 16);
            }
            this.doubleBom[i].setPosition(this.item[4].getX() + (2 + i) * this.player[9].getWidth(), this.item[4].getY());
            this.doubleBom[i].setVisible(false);
            this.lm.append((Layer)this.doubleBom[i]);
        }
        this.doubleBom[0].setVisible(true);
    }

    private void itemAction() {
        for (int i = 0; i < this.item.length; ++i) {
            this.item[i].nextFrame();
        }
        this.player[6].nextFrame();
        this.shield.nextFrame();
        if (this.time % 20 == 0) {
            this.player[7].setFrameSequence(this.gameDesign.CHAR124seqDown);
        } else if (this.time % 20 == 10) {
            this.player[7].setFrameSequence(this.gameDesign.CHAR124seqLose);
        }
        this.player[8].move(this.player[8].getWidth() / 4, 0);
        if (this.player[8].getX() > this.getWidth()) {
            this.player[8].setPosition(this.item[3].getX() + 2 * this.player[8].getWidth(), this.item[3].getY());
        }
        this.player[8].nextFrame();
        this.player[9].move(this.player[9].getWidth() / 6, 0);
        if (this.player[9].getX() > this.getWidth()) {
            this.player[9].setPosition(this.item[2].getX() + 2 * this.player[9].getWidth(), this.item[2].getY() - 5);
        }
        this.player[10].setPosition(this.player[9].getX(), this.player[9].getY() + 10);
        this.player[9].nextFrame();
        this.player[10].nextFrame();
        if (this.time % 60 < 10) {
            this.doubleBom[1].setVisible(false);
        } else if (this.time % 60 < 20) {
            this.doubleBom[1].setVisible(true);
        } else if (this.time % 60 < 30) {
            this.doubleBom[2].setVisible(true);
        } else if (this.time % 60 < 40) {
            this.doubleBom[3].setVisible(true);
        } else if (this.time % 60 < 50) {
            this.doubleBom[1].setVisible(false);
            this.doubleBom[2].setVisible(false);
            this.doubleBom[3].setVisible(false);
            this.doubleBom[0].setVisible(false);
        } else {
            this.doubleBom[0].setVisible(true);
        }
    }

    private void initBom() throws IOException {
        this.bom[this.bomLength * 4 + 1].setImage(this.gameDesign.getBom20(), 20, 20);
        this.bom[this.bomLength * 4 + 1].setFrameSequence(this.gameDesign.BOM20seq001);
        this.bom[this.bomLength * 4 + 1].setPosition(this.item[5].getX() + 2 * this.player[9].getWidth(), this.item[5].getY());
        this.bom[this.bomLength * 4 + 1].setVisible(true);
        this.initBomDestroy();
    }

    private void initBomDestroy() throws IOException {
        int j;
        for (int i = 0; i < this.bomLength * 4 + 1; ++i) {
            this.bom[i].setVisible(false);
        }
        int xBom = this.bom[this.bomLength * 4 + 1].getX();
        int yBom = this.bom[this.bomLength * 4 + 1].getY();
        int feetMove = this.bom[this.bomLength * 4 + 1].getWidth();
        this.bom[0].setFrameSequence(this.gameDesign.BOM24seqCenter);
        this.bom[0].setPosition(xBom, yBom);
        for (j = 0; j < this.bomLength; ++j) {
            this.bom[1 + j * 4].setFrameSequence(this.gameDesign.BOM24seqRight);
            this.bom[1 + j * 4].setPosition(xBom + (j + 1) * feetMove, yBom);
        }
        for (j = 0; j < this.bomLength; ++j) {
            this.bom[2 + j * 4].setFrameSequence(this.gameDesign.BOM24seqDown);
            this.bom[2 + j * 4].setPosition(xBom, yBom + (j + 1) * feetMove);
        }
        for (j = 0; j < this.bomLength; ++j) {
            this.bom[3 + j * 4].setFrameSequence(this.gameDesign.BOM24seqLeft);
            this.bom[3 + j * 4].setPosition(xBom - (j + 1) * feetMove, yBom);
        }
        for (j = 0; j < this.bomLength; ++j) {
            this.bom[4 + j * 4].setFrameSequence(this.gameDesign.BOM24seqUp);
            this.bom[4 + j * 4].setPosition(xBom, yBom - (j + 1) * feetMove);
        }
    }

    private void bomAction() throws IOException {
        int i;
        if (!this.readyBom) {
            this.bom[4 * this.bomLength + 1].nextFrame();
        }
        if (this.bom[4 * this.bomLength + 1].getFrame() == 8 && !this.readyBom) {
            ++this.timeBom;
            if (this.timeBom == 3) {
                this.bom[4 * this.bomLength + 1].setVisible(false);
                this.bom[4 * this.bomLength + 1].setImage(this.gameDesign.getBom24(), 24, 24);
                if (this.sunnetCanvas.sizeMode == 2) {
                    this.bom[4 * this.bomLength + 1].setImage(this.gameDesign.getBom20(), 20, 20);
                }
                this.readyBom = true;
                for (i = 0; i < this.bomLength * 4 + 1; ++i) {
                    this.bom[i].setVisible(true);
                    this.destroyBom = true;
                }
            }
        }
        if (this.destroyBom) {
            ++this.timeDestroy;
            if (this.timeDestroy == 4) {
                for (i = 0; i < this.bomLength * 4 + 1; ++i) {
                    this.bom[i].setVisible(false);
                }
                this.destroyBom = false;
                ++this.nextBom;
            }
        }
        if (this.nextBom > 0) {
            ++this.nextBom;
            if (this.nextBom == 10) {
                this.nextBom = 0;
                this.readyBom = false;
                this.timeBom = 0;
                this.timeDestroy = 0;
                this.bomLength = this.bomLength == 1 ? 2 : 1;
                this.initBom();
            }
        }
    }

    public void clean(Graphics g) {
        this.isPlay = false;
        this.gameThread = null;
        this.gameDesign = null;
        this.player = null;
        this.enemy = null;
        this.item = null;
        this.shield = null;
        this.bom = null;
        this.doubleBom = null;
        this.note = null;
        this.lm = null;
        this.font = null;
        this.removeCommand(this.backCommand);
        this.backCommand = null;
        g = null;
        Runtime.getRuntime().gc();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.backCommand) {
            try {
                Graphics g = this.getGraphics();
                g.setColor(0, 0, 0);
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                g.setColor(255, 0, 0);
                g.setFont(Font.getFont((int)64, (int)1, (int)0));
                g.drawString("NOW LOADING...", this.getWidth() / 2, this.getHeight() / 2, 17);
                this.flushGraphics();
                this.clean(g);
                Thread.sleep(3000L);
                this.sunnetCanvas.midlet.display.setCurrent((Displayable)this.sunnetCanvas);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    public void start() {
        this.gameThread = new Thread(this);
        this.gameThread.start();
    }

    private void drawScreen(Graphics g) {
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.lm.paint(g, 0, 0);
        g.setFont(Font.getFont((int)64, (int)1, (int)8));
        g.setColor(0, 0, 255);
        g.drawString(this.note[0], this.player[0].getX() - 40, this.player[0].getY(), 20);
        g.setColor(255, 0, 0);
        g.drawString(this.note[1], this.enemy[0].getX() - 40, this.enemy[0].getY(), 20);
        g.setColor(0, 255, 0);
        g.drawString(this.note[2], this.enemy[0].getX() - 40, this.enemy[0].getY() + this.enemy[0].getHeight(), 20);
        g.setColor(255, 255, 255);
        g.drawString(this.note[3], this.item[0].getX() - 60, this.item[0].getY() + 5, 20);
        g.drawString(this.note[4], this.item[0].getX() - 60, this.item[1].getY() + 5, 20);
        g.drawString(this.note[5], this.item[0].getX() - 60, this.item[2].getY() + 5, 20);
        g.drawString(this.note[6], this.item[0].getX() - 60, this.item[3].getY() + 5, 20);
        g.drawString(this.note[7], this.item[0].getX() - 60, this.item[4].getY() + 5, 20);
        g.drawString(this.note[8], this.item[0].getX() - 60, this.item[5].getY() + 5, 20);
        g.drawString(this.note[9], this.item[0].getX() - 60, this.item[6].getY() + 5, 20);
        g.drawString(this.note[10], this.item[0].getX() - 60, this.item[7].getY() + 5, 20);
        g.drawString(this.note[11], this.item[0].getX() - 60, this.item[8].getY() + 5, 20);
        g.setFont(Font.getFont((int)64, (int)2, (int)8));
        g.drawString(this.note[12], this.item[0].getX() + 2 * this.player[0].getWidth(), this.item[6].getY() + 5, 20);
        g.drawString("??????", this.item[0].getX() + 2 * this.player[0].getWidth(), this.item[7].getY() + 5, 20);
        g.drawString("$+++", this.item[0].getX() + 2 * this.player[0].getWidth(), this.item[8].getY() + 5, 20);
        this.flushGraphics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Graphics g = this.getGraphics();
        Thread currentThread = Thread.currentThread();
        try {
            while (true) {
                long timeTake;
                if (currentThread != this.gameThread) {
                    g = null;
                    currentThread = null;
                    Runtime.getRuntime().gc();
                    return;
                }
                long startTime = System.currentTimeMillis();
                if (this.isShown() && this.isPlay) {
                    this.action();
                    this.drawScreen(g);
                    Runtime.getRuntime().gc();
                }
                if ((timeTake = System.currentTimeMillis() - startTime) < this.delay) {
                    HelpScreen helpScreen = this;
                    synchronized (helpScreen) {
                        this.wait(this.delay - timeTake);
                        continue;
                    }
                }
                Thread.currentThread();
                Thread.yield();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

