/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class MainPlayer
extends Character {
    int viewPortX;
    int viewPortY;
    int dx;
    int dy;
    int rightPress;
    int leftPress;
    int upPress;
    int downPress;
    int lostGold = 0;
    int lostGoldValue = 0;
    int lostLife = 0;
    int lostLifeValue = 0;
    int lostBom = 0;
    int lostBomValue = 0;
    int shieldPress;
    int needlePress;
    int dying = 0;

    public MainPlayer(GameDesign gameDesign, byte[][] matrix, byte[][] floor, LayerManager lm, TiledLayer map, Vector character, int dx, int dy, int life, int countNeedle, int countShield, int score, int sizeMode) throws IOException {
        this.gameDesign = gameDesign;
        this.sizeMode = sizeMode;
        this.bomVector = new Vector();
        this.feetMove = 24;
        this.sprite = new Sprite(gameDesign.getChar124(), 24, 24);
        this.shield = new Sprite(gameDesign.getShield30(), 30, 30);
        this.turtle = new Sprite(gameDesign.getChar124(), 24, 24);
        if (sizeMode == 2) {
            this.feetMove = 18;
            this.sprite.setImage(gameDesign.getChar118(), 18, 18);
            this.shield.setImage(gameDesign.getShield24(), 24, 24);
            this.turtle.setImage(gameDesign.getChar118(), 18, 18);
        }
        this.sprite.setFrameSequence(gameDesign.CHAR124seqRight);
        this.direct = 1;
        this.sprite.setPosition(dx * this.feetMove, dy * this.feetMove);
        this.shield.setVisible(false);
        this.turtle.setVisible(false);
        this.matrix = matrix;
        this.floor = floor;
        this.lm = lm;
        this.map = map;
        this.character = character;
        this.dy = dy;
        this.dx = dx;
        this.viewPortX = 0;
        this.viewPortY = 0;
        this.life = life;
        this.countNeedle = countNeedle;
        this.countShield = countShield;
        this.isPlayer = true;
        this.score = score;
        this.leftPress = 0;
        this.upPress = 0;
        this.rightPress = 0;
        this.downPress = 0;
        this.shieldPress = 0;
        this.needlePress = 0;
        lm.append((Layer)this.shield);
        lm.append((Layer)this.turtle);
        lm.append((Layer)this.sprite);
        this.adjustViewport(this.sprite.getX(), this.sprite.getY());
    }

    public void keyInputPlayer(int keyState) throws IOException, InterruptedException {
        if (this.haste && this.stillGoDown == 0 && this.stillGoLeft == 0 && this.stillGoUp == 0 && this.stillGoRight == 0) {
            this.sizeFeet = 4;
        }
        if (this.upPress == 1 && this.moveUp && this.alive == 0) {
            if (!this.turtle.isVisible()) {
                this.sprite.setFrameSequence(this.gameDesign.CHAR124seqUp);
            } else {
                this.sprite.setFrameSequence(this.gameDesign.HORSE124Up);
                this.turtle.setFrameSequence(this.gameDesign.CHAR124seqUp);
            }
            this.goUp();
            this.direct = 4;
            this.adjustViewport(this.viewPortX, this.viewPortY - this.feetMove / this.sizeFeet);
        } else if (this.downPress == 1 && this.moveDown && this.alive == 0) {
            if (!this.turtle.isVisible()) {
                this.sprite.setFrameSequence(this.gameDesign.CHAR124seqDown);
            } else {
                this.sprite.setFrameSequence(this.gameDesign.HORSE124Down);
                this.turtle.setFrameSequence(this.gameDesign.CHAR124seqDown);
            }
            this.goDown();
            this.direct = 2;
            this.adjustViewport(this.viewPortX, this.viewPortY + this.feetMove / this.sizeFeet);
        } else if (this.leftPress == 1 && this.moveLeft && this.alive == 0) {
            if (!this.turtle.isVisible()) {
                this.sprite.setFrameSequence(this.gameDesign.CHAR124seqLeft);
            } else {
                this.sprite.setFrameSequence(this.gameDesign.HORSE124Left);
                this.turtle.setFrameSequence(this.gameDesign.CHAR124seqLeft);
            }
            this.goLeft();
            this.direct = 3;
            this.adjustViewport(this.viewPortX - this.feetMove / this.sizeFeet, this.viewPortY);
        } else if (this.rightPress == 1 && this.moveRight && this.alive == 0) {
            if (!this.turtle.isVisible()) {
                this.sprite.setFrameSequence(this.gameDesign.CHAR124seqRight);
            } else {
                this.sprite.setFrameSequence(this.gameDesign.HORSE124Right);
                this.turtle.setFrameSequence(this.gameDesign.CHAR124seqRight);
            }
            this.goRight();
            this.direct = 1;
            this.adjustViewport(this.viewPortX + this.feetMove / this.sizeFeet, this.viewPortY);
        }
        if ((keyState & 0x100) != 0 && this.fire && this.alive == 0 && this.fireBom >= 5) {
            this.setBom();
        }
    }

    protected void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
        int keyAction = this.getGameAction(keyCode);
        switch (keyAction) {
            case 1: {
                this.upPress = 0;
                break;
            }
            case 6: {
                this.downPress = 0;
                break;
            }
            case 2: {
                this.leftPress = 0;
                break;
            }
            case 5: {
                this.rightPress = 0;
            }
        }
    }

    protected void keyPressed(int keyCode) {
        super.keyPressed(keyCode);
        int keyAction = this.getGameAction(keyCode);
        switch (keyAction) {
            case 1: {
                this.upPress = 1;
                break;
            }
            case 6: {
                this.downPress = 1;
                break;
            }
            case 2: {
                this.leftPress = 1;
                break;
            }
            case 5: {
                this.rightPress = 1;
            }
        }
        switch (keyCode) {
            case 49: {
                if (this.countShield <= 0 || this.shield.isVisible()) break;
                --this.countShield;
                this.shield.setVisible(true);
                break;
            }
            case 51: {
                if (this.countNeedle <= 0 || this.alive >= 20 || this.alive <= 0) break;
                --this.countNeedle;
                this.alive = 0;
                this.isMove = true;
                this.fire = true;
                this.stillGoUp = 0;
                this.stillGoLeft = 0;
                this.stillGoRight = 0;
                this.stillGoDown = 0;
                this.sprite.setFrameSequence(this.gameDesign.CHAR124seqDown);
                this.direct = 2;
                this.dieState = false;
            }
        }
    }

    protected void isNotMovedCharater() {
        this.moveUp = true;
        this.moveDown = true;
        this.moveLeft = true;
        this.moveRight = true;
        if (this.shield.isVisible()) {
            this.shield.nextFrame();
        }
        if (this.stillGoRight > 0) {
            if (this.stillGoRight < this.sizeFeet) {
                this.sprite.move(this.feetMove / this.sizeFeet, 0);
                this.sprite.nextFrame();
                if (this.turtle.isVisible()) {
                    this.turtle.nextFrame();
                }
                this.adjustViewport(this.viewPortX + this.feetMove / this.sizeFeet, this.viewPortY);
                ++this.stillGoRight;
                if (this.feetMove - this.feetMove / this.sizeFeet * this.stillGoRight == 0) {
                    this.sprite.setFrame(0);
                    this.stillGoRight = 0;
                    this.isMove = true;
                }
            } else if (this.stillGoRight == this.sizeFeet) {
                this.sprite.move(this.feetMove - this.feetMove / this.sizeFeet * this.stillGoRight, 0);
                this.sprite.setFrame(0);
                this.stillGoRight = 0;
                this.isMove = true;
            }
        } else if (this.stillGoLeft > 0) {
            if (this.stillGoLeft < this.sizeFeet) {
                this.sprite.move(-this.feetMove / this.sizeFeet, 0);
                this.sprite.nextFrame();
                if (this.turtle.isVisible()) {
                    this.turtle.nextFrame();
                }
                ++this.stillGoLeft;
                this.adjustViewport(this.viewPortX - this.feetMove / this.sizeFeet, this.viewPortY);
                if (this.feetMove - this.feetMove / this.sizeFeet * this.stillGoLeft == 0) {
                    this.sprite.setFrame(0);
                    this.stillGoLeft = 0;
                    this.isMove = true;
                }
            } else if (this.stillGoLeft == this.sizeFeet) {
                this.sprite.move(-this.feetMove + this.feetMove / this.sizeFeet * this.stillGoLeft, 0);
                this.sprite.setFrame(0);
                this.stillGoLeft = 0;
                this.isMove = true;
            }
        } else if (this.stillGoUp > 0) {
            if (this.stillGoUp < this.sizeFeet) {
                this.sprite.move(0, -this.feetMove / this.sizeFeet);
                this.sprite.nextFrame();
                if (this.turtle.isVisible()) {
                    this.turtle.nextFrame();
                }
                ++this.stillGoUp;
                this.adjustViewport(this.viewPortX, this.viewPortY - this.feetMove / this.sizeFeet);
                if (this.feetMove - this.feetMove / this.sizeFeet * this.stillGoUp == 0) {
                    this.sprite.setFrame(0);
                    this.stillGoUp = 0;
                    this.isMove = true;
                }
            } else if (this.stillGoUp == this.sizeFeet) {
                this.sprite.move(0, -this.feetMove + this.feetMove / this.sizeFeet * this.stillGoUp);
                this.sprite.setFrame(0);
                this.stillGoUp = 0;
                this.isMove = true;
            }
        } else if (this.stillGoDown > 0) {
            if (this.stillGoDown < this.sizeFeet) {
                this.sprite.move(0, this.feetMove / this.sizeFeet);
                this.sprite.nextFrame();
                if (this.turtle.isVisible()) {
                    this.turtle.nextFrame();
                }
                ++this.stillGoDown;
                this.adjustViewport(this.viewPortX, this.viewPortY + this.feetMove / this.sizeFeet);
                if (this.feetMove - this.feetMove / this.sizeFeet * this.stillGoDown == 0) {
                    this.sprite.setFrame(0);
                    this.stillGoDown = 0;
                    this.isMove = true;
                }
            } else if (this.stillGoDown == this.sizeFeet) {
                this.sprite.move(0, this.feetMove - this.feetMove / this.sizeFeet * this.stillGoDown);
                this.sprite.setFrame(0);
                this.stillGoDown = 0;
                this.isMove = true;
            }
        }
        this.shield.setPosition(this.sprite.getX() - 3, this.sprite.getY() - 5);
        this.turtle.setPosition(this.sprite.getX(), this.sprite.getY() - 10);
    }

    private void adjustViewport(int x, int y) {
        int sx = this.sprite.getX();
        int sy = this.sprite.getY();
        int xmin = this.viewPortX + 3 * this.feetMove;
        int xmax = this.viewPortX + this.getWidth() - 4 * this.feetMove;
        int ymin = this.viewPortY + 3 * this.feetMove;
        int ymax = this.viewPortY + this.getHeight() - 4 * this.feetMove;
        if (sx >= xmin && sx <= xmax && sy >= ymin && sy <= ymax) {
            return;
        }
        if (this.direct == 3 && sx >= xmin) {
            return;
        }
        if (this.direct == 1 && sx <= xmax) {
            return;
        }
        if (this.direct == 4 && sy >= ymin) {
            return;
        }
        if (this.direct == 2 && sy <= ymax) {
            return;
        }
        this.viewPortX = x < this.map.getX() ? this.map.getX() : (x > this.map.getX() + this.map.getWidth() - this.getWidth() ? this.map.getX() + this.map.getWidth() - this.getWidth() : x);
        this.viewPortY = y < this.map.getY() ? this.map.getY() : (y > this.map.getY() + this.map.getHeight() - this.getHeight() ? this.map.getY() + this.map.getHeight() - this.getHeight() : y);
        this.lm.setViewWindow(this.viewPortX, this.viewPortY, this.getWidth(), this.getHeight());
    }

    public void reBorn() {
        ++this.fireBom;
        if (this.alive > 20) {
            this.sprite.nextFrame();
            if (this.sprite.getFrame() == 3) {
                ++this.dying;
            }
            if (this.life > 0 && this.dying == 5) {
                this.dieState = false;
                this.dying = 0;
                this.sizeFeet = 6;
                this.haste = false;
                --this.life;
                this.alive = 0;
                this.isMove = true;
                this.bomCount = 1;
                this.stillGoUp = 0;
                this.stillGoLeft = 0;
                this.stillGoRight = 0;
                this.stillGoDown = 0;
                this.viewPortX = 0;
                this.viewPortY = 0;
                this.sprite.setPosition(this.dx * this.feetMove, this.dy * this.feetMove);
                this.sprite.setFrameSequence(this.gameDesign.CHAR124seqRight);
                this.direct = 1;
                this.bomLength = 1;
                this.fire = true;
                this.fireBom = 0;
                this.lm.setViewWindow(this.sprite.getX() - 3 * this.feetMove, this.sprite.getY() - 3 * this.feetMove, this.getWidth(), this.getHeight());
                this.adjustViewport(this.sprite.getX(), this.sprite.getY());
            }
        }
    }
}

