/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;

public class GhostMoving {
    private final int MOVING;
    private final int STOP;
    public int ANIMATION_STEP;
    private int grid_current_ghostx;
    private int grid_current_ghosty;
    private int real_current_ghostx;
    private int real_current_ghosty;
    private int initialLocationX;
    private int initialLocationY;
    private int initialDirectionX;
    private int initialDirectionY;
    private int x_direction;
    private int y_direction;
    private int moveCounter = 0;
    private int trapCounter = 0;
    private int trapTime = 50;
    private final int TRAPPED;
    private int state = 10;
    int posibility;
    private Random random = new Random();
    private boolean isSetLevel = false;

    public GhostMoving(int grid_current_ghostx, int grid_current_ghosty, int real_current_ghostx, int real_current_ghosty, int direction) {
        this.MOVING = 1;
        this.STOP = 0;
        this.TRAPPED = 10;
        this.grid_current_ghostx = grid_current_ghostx;
        this.grid_current_ghosty = grid_current_ghosty;
        this.real_current_ghostx = real_current_ghostx;
        this.real_current_ghosty = real_current_ghosty;
        if (direction == 1) {
            this.x_direction = -1;
            this.y_direction = 0;
            this.posibility = 5;
        } else if (direction == 2) {
            this.x_direction = 1;
            this.y_direction = 0;
            this.posibility = 6;
        } else if (direction == 3) {
            this.x_direction = 0;
            this.y_direction = -1;
            this.posibility = 7;
        } else {
            this.x_direction = 1;
            this.y_direction = 0;
            this.posibility = 8;
        }
        this.initialDirectionX = this.x_direction;
        this.initialDirectionY = this.y_direction;
        this.initialLocationX = grid_current_ghostx;
        this.initialLocationY = grid_current_ghosty;
        this.ANIMATION_STEP = Maze.ANIMATION_STEP;
    }

    public void resetStatus() {
        this.x_direction = this.initialDirectionX;
        this.y_direction = this.initialDirectionY;
        this.grid_current_ghostx = this.initialLocationX;
        this.grid_current_ghosty = this.initialLocationY;
        this.real_current_ghostx = MazeData.calcGridX(this.grid_current_ghostx);
        this.real_current_ghosty = MazeData.calcGridY(this.grid_current_ghosty);
        this.state = 10;
        this.trapCounter = 0;
        this.moveCounter = 0;
    }

    public void changeDirectionXtoY(boolean mustChange) {
        if (!mustChange && this.random.nextInt(11) > this.posibility) {
            return;
        }
        MoveDecision goUp = new MoveDecision(this.grid_current_ghostx, this.grid_current_ghosty - 1, this.isSetLevel);
        MoveDecision goDown = new MoveDecision(this.grid_current_ghostx, this.grid_current_ghosty + 1, this.isSetLevel);
        goUp.evaluate();
        goDown.evaluate();
        if (goUp.score < 0 && goDown.score < 0) {
            return;
        }
        MoveDecision GoContinue = new MoveDecision(this.grid_current_ghostx + this.x_direction, this.grid_current_ghosty, this.isSetLevel);
        GoContinue.evaluate();
        if (GoContinue.score > 0 && GoContinue.score > goUp.score && GoContinue.score > goDown.score) {
            return;
        }
        int decision = -1;
        if (goUp.score < 0) {
            decision = 1;
        } else if (goDown.score > 0) {
            if (!this.isSetLevel) {
                if (this.random.nextInt(11) > 10 - this.posibility) {
                    decision = 1;
                }
            } else if (goDown.score > goUp.score) {
                decision = 1;
            }
        }
        this.y_direction = decision;
        this.x_direction = 0;
    }

    public void changeDirectionYtoX(boolean mustChange) {
        if (!mustChange && this.random.nextInt(11) > this.posibility) {
            return;
        }
        MoveDecision goLeft = new MoveDecision(this.grid_current_ghostx - 1, this.grid_current_ghosty, this.isSetLevel);
        MoveDecision goRight = new MoveDecision(this.grid_current_ghostx + 1, this.grid_current_ghosty, this.isSetLevel);
        goLeft.evaluate();
        goRight.evaluate();
        if (goLeft.score < 0 && goRight.score < 0) {
            return;
        }
        MoveDecision GoContinue = new MoveDecision(this.grid_current_ghostx, this.grid_current_ghosty + this.y_direction, this.isSetLevel);
        GoContinue.evaluate();
        if (GoContinue.score > 0 && GoContinue.score > goLeft.score && GoContinue.score > goRight.score) {
            return;
        }
        int decision = -1;
        if (goLeft.score < 0) {
            decision = 1;
        } else if (goRight.score > 0) {
            if (!this.isSetLevel) {
                if (this.random.nextInt(11) > 10 - this.posibility) {
                    decision = 1;
                }
            } else if (goRight.score > goLeft.score) {
                decision = 1;
            }
        }
        this.x_direction = decision;
        this.y_direction = 0;
    }

    public void ghostMoveHorizontally() {
        ++this.moveCounter;
        if (this.moveCounter > this.ANIMATION_STEP - 1) {
            this.moveCounter = 0;
            this.grid_current_ghostx += this.x_direction;
            this.real_current_ghostx = MazeData.calcGridX(this.grid_current_ghostx);
            int ghost_nextX = this.x_direction + this.grid_current_ghostx;
            if (this.grid_current_ghosty == 14 && (ghost_nextX <= 1 || ghost_nextX >= 28)) {
                if (ghost_nextX < -1 && this.x_direction < 0) {
                    this.grid_current_ghostx = 29;
                    this.real_current_ghostx = MazeData.calcGridX(this.grid_current_ghostx);
                } else if (ghost_nextX > 30 && this.x_direction > 0) {
                    this.grid_current_ghostx = 0;
                    this.real_current_ghostx = MazeData.calcGridX(this.grid_current_ghostx);
                }
            } else if (ghost_nextX < 0 || ghost_nextX > 29) {
                this.changeDirectionXtoY(true);
            } else if (MazeData.getData(ghost_nextX, this.grid_current_ghosty) == 1) {
                this.changeDirectionXtoY(true);
            } else {
                this.changeDirectionXtoY(false);
            }
        } else {
            this.real_current_ghostx += this.x_direction * Maze.MOVE_SPEED_X;
        }
    }

    public void ghostMoveVertically() {
        ++this.moveCounter;
        if (this.moveCounter > this.ANIMATION_STEP - 1) {
            this.moveCounter = 0;
            this.grid_current_ghosty += this.y_direction;
            this.real_current_ghosty = MazeData.calcGridY(this.grid_current_ghosty);
            int nextY = this.y_direction + this.grid_current_ghosty;
            if (nextY < 0 || nextY > 29) {
                this.changeDirectionYtoX(true);
            } else if (MazeData.getData(this.grid_current_ghostx, nextY) == 1) {
                this.changeDirectionYtoX(true);
            } else {
                this.changeDirectionYtoX(false);
            }
        } else {
            this.real_current_ghosty += this.y_direction * Maze.MOVE_SPEED_Y;
        }
    }

    public void moveHorizontallyInCage() {
        ++this.moveCounter;
        if (this.moveCounter > this.ANIMATION_STEP - 1) {
            this.moveCounter = 0;
            this.grid_current_ghostx += this.x_direction;
            this.real_current_ghostx = MazeData.calcGridX(this.grid_current_ghostx);
            int nextX = this.x_direction + this.grid_current_ghostx;
            if (nextX < 12) {
                this.x_direction = 0;
                this.y_direction = 1;
            } else if (nextX > 17) {
                this.x_direction = 0;
                this.y_direction = -1;
            }
        } else {
            this.real_current_ghostx += this.x_direction * Maze.MOVE_SPEED_X;
        }
    }

    public void moveVerticallyInCage() {
        ++this.moveCounter;
        if (this.moveCounter > this.ANIMATION_STEP - 1) {
            this.moveCounter = 0;
            this.grid_current_ghosty += this.y_direction;
            this.real_current_ghosty = MazeData.calcGridY(this.grid_current_ghosty);
            int nextY = this.y_direction + this.grid_current_ghosty;
            if (nextY < 13) {
                this.y_direction = 0;
                this.x_direction = -1;
            } else if (nextY > 15) {
                this.y_direction = 0;
                this.x_direction = 1;
            }
        } else {
            this.real_current_ghosty += this.y_direction * Maze.MOVE_SPEED_Y;
        }
    }

    public void ghost_moveOneStep() {
        if (this.state == 1 || this.state == 10) {
            if (this.x_direction != 0) {
                if (this.state == 1) {
                    this.ghostMoveHorizontally();
                } else {
                    this.moveHorizontallyInCage();
                }
            } else if (this.y_direction != 0) {
                if (this.state == 1) {
                    this.ghostMoveVertically();
                } else {
                    this.moveVerticallyInCage();
                }
            }
            if (this.state == 10) {
                ++this.trapCounter;
                if (this.trapCounter > this.trapTime && this.grid_current_ghostx == 14 && this.grid_current_ghosty == 13) {
                    this.grid_current_ghosty = 12;
                    this.x_direction = 0;
                    this.y_direction = -1;
                    this.state = 1;
                }
            }
        }
    }

    public int getReal_current_ghosx() {
        return this.real_current_ghostx;
    }

    public int getReal_current_ghosy() {
        return this.real_current_ghosty;
    }

    public int getGrid_current_ghosx() {
        return this.grid_current_ghostx;
    }

    public int getGrid_current_ghosy() {
        return this.grid_current_ghosty;
    }

    public void setLevel(boolean isSetLevel) {
        this.isSetLevel = isSetLevel;
    }
}

