/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class Maze
extends GameCanvas
implements Runnable {
    Recorded rc;
    private int w;
    private int h;
    private int sprite_w = 0;
    private int sprite_h = 0;
    private Font font;
    private final int BACKGROUND;
    private MazeData maze_Data;
    public int magic_dot_radius;
    public int level = 1;
    public boolean soundEnable = false;
    public boolean isgameOver = false;
    public boolean pauseEnable = false;
    public boolean notStopRun = true;
    public boolean sorry_quitgamepls = false;
    public static int grid_current_x = 15;
    public static int grid_current_y = 18;
    public static int real_current_x;
    public static int real_current_y;
    public int currentImage = 0;
    public int moveCounter = 0;
    public int x_direction = 0;
    public int y_direction = 0;
    public int state = 1;
    public static int ANIMATION_STEP;
    public static int MOVE_SPEED_X;
    public static int MOVE_SPEED_Y;
    public static final int MOVING = 1;
    public static final int STOP = 0;
    public final int MOVE_LEFT;
    public final int MOVE_UP;
    public final int MOVE_RIGHT;
    public final int MOVE_DOWN;
    public int currentDirection = 4;
    public int keyboardBuffer = -1;
    public int dotEatenCount = 0;
    public int extraFoodCount = 0;
    public int score = 0;
    public int[] grid_current_ghostx = new int[]{13, 14, 15, 16};
    public int[] grid_current_ghosty = new int[]{14, 14, 14, 14};
    public int[] real_current_ghostx = new int[4];
    public int[] real_current_ghosty = new int[4];
    public static boolean[] isHollow;
    public boolean[] eatMagic = new boolean[]{false, false, false, false};
    public int distanceThreshold;
    public int ghostEatenCount = 0;
    public int lives = 3;
    Graphics g;
    Sprite SunnetMIDlet;
    Sprite extraFood;
    PacManDesign pacmanDesign;
    Sprite[] ghost = new Sprite[4];
    GhostMoving[] ghost_moving = new GhostMoving[4];
    Player player = null;
    Thread t;

    public Maze(int level, boolean sounEnable) {
        super(true);
        this.BACKGROUND = 0;
        this.MOVE_LEFT = 0;
        this.MOVE_UP = 1;
        this.MOVE_RIGHT = 2;
        this.MOVE_DOWN = 3;
        this.setFullScreenMode(true);
        this.h = this.getHeight();
        this.w = this.getWidth();
        this.score = 0;
        this.lives = 3;
        this.notStopRun = true;
        this.level = level;
        this.soundEnable = sounEnable;
        this.isgameOver = false;
        this.t = new Thread(this);
        this.t.start();
    }

    public void suspend() {
    }

    public void resume() {
    }

    public void creat() {
        try {
            int i;
            this.font = Font.getFont((int)0, (int)0, (int)0);
            this.maze_Data = new MazeData(this.w, this.h);
            this.distanceThreshold = Math.min(MazeData.GRID_GAP_X, MazeData.GRID_GAP_Y);
            this.magic_dot_radius = MazeData.GRID_GAP_X;
            MOVE_SPEED_X = MazeData.GRID_GAP_X / ANIMATION_STEP;
            MOVE_SPEED_Y = MazeData.GRID_GAP_Y / ANIMATION_STEP;
            this.pacmanDesign = new PacManDesign();
            this.SunnetMIDlet = this.pacmanDesign.getPacman();
            this.SunnetMIDlet.setFrameSequence(this.pacmanDesign.Pacmanseq001);
            this.SunnetMIDlet.setVisible(true);
            this.sprite_w = this.SunnetMIDlet.getWidth();
            this.sprite_h = this.SunnetMIDlet.getHeight();
            this.extraFood = this.pacmanDesign.getExtraFood();
            this.extraFood.setFrameSequence(this.pacmanDesign.extraFoodseq001);
            this.extraFood.setVisible(true);
            this.ghost[0] = this.pacmanDesign.getGhost1();
            this.ghost[1] = this.pacmanDesign.getGhost2();
            this.ghost[2] = this.pacmanDesign.getGhost3();
            this.ghost[3] = this.pacmanDesign.getGhost4();
            for (i = 0; i < 4; ++i) {
                this.ghost[i].setFrameSequence(this.pacmanDesign.Pacmanseq00[i]);
                this.ghost[i].setVisible(true);
            }
            for (i = 0; i < 4; ++i) {
                this.real_current_ghostx[i] = MazeData.calcGridX(this.grid_current_ghostx[i]);
                this.real_current_ghosty[i] = MazeData.calcGridY(this.grid_current_ghosty[i]);
                this.ghost_moving[i] = new GhostMoving(this.grid_current_ghostx[i], this.grid_current_ghosty[i], this.real_current_ghostx[i], this.real_current_ghosty[i], i + 1);
                if (this.level <= i) continue;
                this.ghost_moving[i].setLevel(true);
            }
            grid_current_x = 15;
            grid_current_y = 18;
            real_current_x = MazeData.calcGridX(grid_current_x);
            real_current_y = MazeData.calcGridY(grid_current_y);
            this.g = this.getGraphics();
            this.resetState();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void resetPacmanStatus() {
        grid_current_x = 15;
        grid_current_y = 18;
        real_current_x = MazeData.calcGridX(grid_current_x);
        real_current_y = MazeData.calcGridY(grid_current_y);
        this.keyboardBuffer = -1;
        this.currentDirection = 4;
        this.currentImage = 0;
        this.moveCounter = 0;
        this.x_direction = 0;
        this.y_direction = 0;
        this.state = 1;
        this.SunnetMIDlet.setFrameSequence(this.pacmanDesign.Pacmanseq001);
    }

    public void play(String src, int countTime) {
        InputStream in = this.getClass().getResourceAsStream(src);
        try {
            this.player = Manager.createPlayer((InputStream)in, (String)"audio/midi");
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
        try {
            this.player.setLoopCount(countTime);
            this.player.start();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void continuePlay() {
        if (!this.soundEnable) {
            return;
        }
        if (this.player == null) {
            this.play("PacManEat.mid", 1000);
            return;
        }
        System.out.println("playing");
        try {
            this.player.start();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void stopPlay() {
        if (!this.soundEnable) {
            return;
        }
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        } else {
            return;
        }
    }

    public void draw_Maze(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.w, this.h);
        g.setColor(153);
        this.WallRectangle(0, 0, 29, 29, g);
        this.WallRectangle(14, 0, 15, 4, g);
        this.WallRectangle(2, 2, 5, 4, g);
        this.WallRectangle(7, 2, 12, 4, g);
        this.WallRectangle(17, 2, 22, 4, g);
        this.WallRectangle(24, 2, 27, 4, g);
        this.WallRectangle(2, 6, 5, 7, g);
        this.WallRectangle(14, 6, 15, 10, g);
        this.WallRectangle(10, 6, 19, 7, g);
        this.WallRoundRect(10, 6, 19, 7, g);
        this.draw_line(14, 7, 15, 7, g);
        this.WallRectangle(7, 9, 12, 10, g);
        this.WallRectangle(7, 6, 8, 13, g);
        this.WallRoundRect(7, 6, 8, 13, g);
        this.draw_line(8, 9, 8, 10, g);
        this.WallRectangle(17, 9, 22, 10, g);
        this.WallRectangle(21, 6, 22, 13, g);
        this.WallRoundRect(21, 6, 22, 13, g);
        this.draw_line(21, 9, 21, 10, g);
        this.WallRectangle(24, 6, 27, 7, g);
        this.WallRectangle(-1, 9, 5, 13, g);
        this.WallRectangle(24, 9, 30, 13, g);
        this.WallRectangle(10, 12, 19, 17, g);
        g.drawRoundRect(MazeData.calcGridX(10) + 2, MazeData.calcGridY(12) + 2, MazeData.calcGridX(19) - MazeData.calcGridX(10) - 4, MazeData.calcGridY(17) - MazeData.calcGridY(12) - 4, 8, 8);
        g.setColor(0xFFFF00);
        g.fillRect(MazeData.calcGridX(13), MazeData.calcGridY(12), MazeData.calcGridX(16) - MazeData.calcGridX(13), 2);
        g.setColor(0);
        this.WallRectangle(7, 19, 12, 20, g);
        this.WallRectangle(7, 15, 8, 23, g);
        this.WallRoundRect(7, 15, 8, 23, g);
        this.draw_line(8, 19, 8, 20, g);
        this.WallRectangle(17, 19, 22, 20, g);
        this.WallRectangle(21, 15, 22, 23, g);
        this.WallRoundRect(21, 15, 22, 23, g);
        this.draw_line(21, 19, 21, 20, g);
        this.WallRectangle(14, 19, 15, 27, g);
        this.WallRectangle(10, 22, 19, 23, g);
        this.WallRoundRect(10, 22, 19, 23, g);
        this.draw_line(14, 22, 15, 22, g);
        this.draw_line(14, 23, 15, 23, g);
        this.WallRectangle(2, 25, 5, 27, g);
        this.WallRectangle(17, 25, 22, 27, g);
        this.WallRectangle(7, 25, 12, 27, g);
        this.WallRectangle(24, 25, 27, 27, g);
        this.WallRectangle(-1, 15, 5, 17, g);
        this.WallRectangle(4, 19, 5, 23, g);
        this.WallRectangle(2, 19, 5, 20, g);
        g.setColor(0);
        this.draw_line(4, 20, 5, 20, g);
        this.WallRoundRect(2, 19, 5, 20, g);
        this.WallRectangle(-1, 22, 2, 23, g);
        this.WallRectangle(24, 15, 30, 17, g);
        this.WallRectangle(24, 19, 25, 23, g);
        this.WallRectangle(24, 19, 27, 20, g);
        this.WallRoundRect(24, 19, 27, 20, g);
        this.draw_line(24, 20, 25, 20, g);
        this.WallRectangle(27, 22, 30, 23, g);
        g.setColor(0);
        g.fillRect(0, 0, MazeData.calcGridX(0) - 1, this.h);
        g.fillRect(MazeData.calcGridX(29) + 1, 0, this.w - MazeData.calcGridX(29), this.h);
        g.fillRect(MazeData.calcGridX(0), MazeData.calcGridY(13) + 1, 2 * MazeData.GRID_GAP_X, 2 * MazeData.GRID_GAP_Y - 2);
        g.fillRect(MazeData.calcGridX(28), MazeData.calcGridY(13) + 1, 2 * MazeData.GRID_GAP_X, 2 * MazeData.GRID_GAP_Y - 2);
        g.setColor(0xFFFF00);
        this.putDotHorizontally(2, 13, 1, g);
        this.putDotHorizontally(16, 27, 1, g);
        this.putDotHorizontally(2, 27, 5, g);
        this.putDotHorizontally(2, 27, 28, g);
        this.putDotHorizontally(2, 13, 24, g);
        this.putDotHorizontally(16, 27, 24, g);
        this.putDotHorizontally(2, 5, 8, g);
        this.putDotHorizontally(9, 13, 8, g);
        this.putDotHorizontally(16, 20, 8, g);
        this.putDotHorizontally(24, 27, 8, g);
        this.putDotHorizontally(2, 5, 18, g);
        this.putDotHorizontally(9, 13, 21, g);
        this.putDotHorizontally(16, 20, 21, g);
        this.putDotHorizontally(24, 27, 18, g);
        this.putDotHorizontally(2, 3, 21, g);
        this.putDotHorizontally(26, 27, 21, g);
        this.putDotVertically(1, 1, 8, g);
        this.putDotVertically(1, 18, 21, g);
        this.putDotVertically(1, 24, 28, g);
        this.putDotVertically(28, 1, 8, g);
        this.putDotVertically(28, 18, 21, g);
        this.putDotVertically(28, 24, 28, g);
        this.putDotVertically(6, 2, 27, g);
        this.putDotVertically(23, 2, 27, g);
        this.putDotVertically(3, 22, 23, g);
        this.putDotVertically(9, 22, 23, g);
        this.putDotVertically(20, 22, 23, g);
        this.putDotVertically(26, 22, 23, g);
        this.putDotVertically(13, 25, 27, g);
        this.putDotVertically(16, 25, 27, g);
        this.putDotVertically(9, 6, 7, g);
        this.putDotVertically(20, 6, 7, g);
        this.putDotVertically(13, 2, 4, g);
        this.putDotVertically(16, 2, 4, g);
    }

    public void clearCurrent(Graphics g) {
        g.setColor(0);
        g.fillRect(real_current_x - this.sprite_w / 2, real_current_y - this.sprite_h / 2, this.sprite_w, this.sprite_h);
        for (int i = 0; i < 4; ++i) {
            g.fillRect(this.real_current_ghostx[i] - this.sprite_w / 2, this.real_current_ghosty[i] - this.sprite_h / 2, this.sprite_w, this.sprite_h);
            g.setColor(0xFFFF00);
            if (MazeData.isVisible(this.grid_current_ghostx[i], this.grid_current_ghosty[i])) {
                if (MazeData.getData(this.grid_current_ghostx[i], this.grid_current_ghosty[i]) == 2) {
                    g.fillRect(MazeData.calcGridX(this.grid_current_ghostx[i]) - 1, MazeData.calcGridY(this.grid_current_ghosty[i]) - 1, 2, 2);
                } else if (MazeData.getData(this.grid_current_ghostx[i], this.grid_current_ghosty[i]) == 3) {
                    g.fillArc(MazeData.calcGridX(this.grid_current_ghostx[i]) - this.magic_dot_radius / 2, MazeData.calcGridY(this.grid_current_ghosty[i]) - this.magic_dot_radius / 2, this.magic_dot_radius, this.magic_dot_radius, 0, 360);
                }
            }
            g.setColor(0);
        }
    }

    public void drawCurrent(Graphics g) {
        g.setColor(0xFFFF00);
        this.SunnetMIDlet.setPosition(real_current_x - this.sprite_w / 2, real_current_y - this.sprite_h / 2);
        this.SunnetMIDlet.paint(g);
        for (int i = 0; i < 4; ++i) {
            this.ghost[i].setPosition(this.real_current_ghostx[i] - this.sprite_w / 2, this.real_current_ghosty[i] - this.sprite_h / 2);
            this.ghost[i].paint(g);
            g.setColor(0xFFFF00);
            g.fillRect(MazeData.calcGridX(13), MazeData.calcGridY(12), MazeData.calcGridX(16) - MazeData.calcGridX(13), 2);
            g.setColor(0);
        }
    }

    public void run() {
        Form main = new Form("www.sunkhoai.com");
        main.append("Loading program. \n");
        main.append("Please wait..........");
        SunnetFlash.midlet.getDisplay().setCurrent((Displayable)main);
        this.creat();
        int timehollow = 0;
        boolean counSound = true;
        int score_sleep = 1;
        boolean score_visible = false;
        int extraFood_sleep = 1;
        boolean extraFood_visible = false;
        int time_visible = 1;
        int count_enter = 1;
        SunnetFlash.midlet.getDisplay().setCurrent((Displayable)this);
        if (this.soundEnable) {
            this.play("PacManEat.mid", 100);
        }
        this.g.setColor(0);
        while (!this.sorry_quitgamepls) {
            int i;
            int keyState;
            if (!this.notStopRun) continue;
            Runtime.getRuntime().gc();
            if (++count_enter > 30) {
                count_enter = 1;
            }
            while (this.pauseEnable) {
                if (++count_enter > 30) {
                    count_enter = 1;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                this.g.setColor(0);
                this.g.fillRect(MazeData.GRID_GAP_X, 30 * MazeData.GRID_GAP_Y + 3, this.w, this.h - 30 * MazeData.GRID_GAP_Y - 3);
                this.g.setColor(0xFFFF00);
                this.g.setFont(Font.getFont((int)0, (int)1, (int)16));
                this.g.drawString("Pause", this.w / 2, (this.h + 30 * MazeData.GRID_GAP_Y + 3) / 2, 17);
                this.flushGraphics();
                keyState = this.getKeyStates();
                if ((keyState & 0x100) != 0 && count_enter > 5) {
                    this.pauseEnable = false;
                    if (this.soundEnable && this.player != null) {
                        try {
                            this.player.start();
                        }
                        catch (MediaException ex) {
                            ex.printStackTrace();
                        }
                    }
                    count_enter = 1;
                }
                Runtime.getRuntime().gc();
            }
            if (this.isgameOver) continue;
            ++time_visible;
            if (extraFood_visible) {
                this.extraFood.setPosition(MazeData.calcGridX(14) + 3, MazeData.calcGridY(18) - this.sprite_h / 2);
                this.extraFood.paint(this.g);
                ++extraFood_sleep;
                if (grid_current_x == 14 && grid_current_y == 18) {
                    this.score += this.level * 100;
                    ++this.extraFoodCount;
                    if (this.extraFoodCount == 6) {
                        ++this.lives;
                    }
                    this.g.setFont(Font.getFont((int)0, (int)0, (int)8));
                    this.g.drawString("0", MazeData.calcGridX(29) + 4, MazeData.calcGridY(15) + 2 + 3 * this.font.getHeight(), 68);
                    this.g.drawString("0", MazeData.calcGridX(29) + 4, MazeData.calcGridY(15) + 2 + 2 * this.font.getHeight(), 68);
                    this.g.drawString("" + this.level, MazeData.calcGridX(29) + 4, MazeData.calcGridY(15) + 2 + this.font.getHeight(), 68);
                    this.g.setFont(Font.getFont((int)0, (int)0, (int)0));
                    extraFood_visible = false;
                    this.g.setColor(0);
                    this.g.fillRect(MazeData.calcGridX(14) + 3, MazeData.calcGridY(18) - this.sprite_h / 2, this.sprite_w, this.sprite_h);
                    extraFood_sleep = 1;
                    time_visible = 1;
                    score_visible = true;
                }
            }
            if (extraFood_sleep % 100 == 0) {
                extraFood_sleep = 1;
                time_visible = 1;
                extraFood_visible = false;
                this.g.setColor(0);
                this.g.fillRect(MazeData.calcGridX(14) + 3, MazeData.calcGridY(18) - this.sprite_h / 2, this.sprite_w, this.sprite_h);
            }
            if (score_visible) {
                ++score_sleep;
            }
            if (score_sleep % 100 == 0) {
                this.g.setColor(0);
                this.g.fillRect(MazeData.calcGridX(29) + 1, 0, this.w - MazeData.calcGridX(29), this.h);
                score_sleep = 1;
                score_visible = false;
            }
            this.SunnetMIDlet.nextFrame();
            for (int i2 = 0; i2 < 4; ++i2) {
                this.ghost[i2].nextFrame();
            }
            this.g.setColor(0);
            this.g.fillRect(MazeData.GRID_GAP_X, 30 * MazeData.GRID_GAP_Y + 3, this.w, this.h - 30 * MazeData.GRID_GAP_Y - 3);
            this.g.setColor(255);
            this.g.setFont(this.font);
            this.g.drawString("Scores: " + this.score + " Lives: " + (this.lives - 1), MazeData.GRID_GAP_X, 30 * MazeData.GRID_GAP_Y + this.font.getHeight() + 3, 68);
            this.g.drawString("Level: " + this.level, MazeData.GRID_GAP_X, 30 * MazeData.GRID_GAP_Y + 2 * this.font.getHeight() + 3, 68);
            this.g.drawString("Exit", this.w - 3, this.h - 10, 72);
            this.g.drawString("Pause", this.w / 2, this.h - 2, 65);
            keyState = this.getKeyStates();
            if ((keyState & 4) != 0) {
                this.setKeyboardBuffer(0);
            } else if ((keyState & 0x20) != 0) {
                this.setKeyboardBuffer(2);
            } else if ((keyState & 2) != 0) {
                this.setKeyboardBuffer(1);
            } else if ((keyState & 0x40) != 0) {
                this.setKeyboardBuffer(3);
            } else if (((keyState & 0xE1) != 0 || (keyState & 0xFFFFFF35) != 0 || (keyState & 0xCD) != 0) & count_enter > 5) {
                this.pauseEnable = true;
                if (this.soundEnable && this.player != null) {
                    try {
                        this.player.stop();
                    }
                    catch (MediaException ex) {
                        ex.printStackTrace();
                    }
                }
                count_enter = 1;
            }
            if (this.isEatMagicDot()) {
                this.setHollow();
                timehollow = 0;
            }
            for (i = 0; i < 4; ++i) {
                if (!isHollow[i]) continue;
                ++timehollow;
                break;
            }
            if (timehollow == 100) {
                for (i = 0; i < 4; ++i) {
                    Maze.isHollow[i] = false;
                }
                this.setGhost();
                for (i = 0; i < 4; ++i) {
                    this.ghost_moving[i].ANIMATION_STEP = 4;
                }
                timehollow = 0;
                this.ghostEatenCount = 0;
            }
            for (i = 0; i < 4; ++i) {
                int k;
                int j;
                int[] y;
                int[] x;
                if (!this.Met(i)) continue;
                if (isHollow[i]) {
                    this.g.setColor(0);
                    this.g.fillRect(MazeData.calcGridX(29) + 1, 0, this.w - MazeData.calcGridX(29), this.h);
                    this.pacmanEateGhost(this.g);
                    score_visible = true;
                    this.g.setColor(0);
                    this.g.fillRect(this.real_current_ghostx[i] - this.sprite_w / 2, this.real_current_ghosty[i] - this.sprite_h / 2, this.sprite_w, this.sprite_h);
                    this.g.setColor(0xFFFF00);
                    x = new int[]{1, 0, -1, 0, 0};
                    y = new int[]{0, 1, 0, -1, 0};
                    for (int k2 = 0; k2 < 5; ++k2) {
                        if (this.grid_current_ghostx[i] <= 0 || this.grid_current_ghostx[i] >= 29 || MazeData.getData(this.grid_current_ghostx[i] + x[k2], this.grid_current_ghosty[i] + y[k2]) != 2 || !MazeData.isVisible(this.grid_current_ghostx[i] + x[k2], this.grid_current_ghosty[i] + y[k2])) continue;
                        this.g.fillRect(MazeData.calcGridX(this.grid_current_ghostx[i] + x[k2]) - 1, MazeData.calcGridY(this.grid_current_ghosty[i] + y[k2]) - 1, 2, 2);
                    }
                    this.ghost_moving[i].resetStatus();
                    this.setGhostMoving();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    this.ghost[i].setFrameSequence(this.pacmanDesign.Pacmanseq00[i]);
                    this.ghost_moving[i].ANIMATION_STEP = 4;
                    Maze.isHollow[i] = false;
                    continue;
                }
                --this.lives;
                this.stopPlay();
                if (this.lives == 0) {
                    SunnetFlash.midlet.rc.write("" + this.score);
                    this.g.setColor(65280);
                    this.g.fillRect(0, 0, this.w, this.getHeight());
                    this.g.setColor(0xFF0033);
                    this.g.drawString("Game Over", this.w / 2, this.h / 2, 65);
                    this.flushGraphics(0, 0, this.w, this.h);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    this.stopPlay();
                    this.isgameOver = true;
                    SunnetFlash.menuCanvas.level = this.level < 5 ? this.level : 4;
                    SunnetFlash.menuCanvas.SoundEnable = this.soundEnable;
                    System.out.println("Before____________________________");
                    SunnetFlash.menuCanvas.Update();
                    System.out.println("After______________________________");
                    this.notStopRun = false;
                    this.sorry_quitgamepls = true;
                    SunnetFlash.midlet.upScore(null, this.score);
                    Runtime.getRuntime().gc();
                    return;
                }
                if (this.isgameOver) continue;
                this.SunnetMIDlet.setFrameSequence(this.pacmanDesign.Pacmanseq0010);
                this.clearCurrent(this.g);
                x = new int[]{1, 0, -1, 0, 0};
                y = new int[]{0, 1, 0, -1, 0};
                this.g.setColor(0xFFFF00);
                for (j = 0; j < 4; ++j) {
                    for (int k3 = 0; k3 < 4; ++k3) {
                        if (this.grid_current_ghostx[j] <= 0 || this.grid_current_ghostx[j] >= 29 || MazeData.getData(this.grid_current_ghostx[j] + x[k3], this.grid_current_ghosty[j] + y[k3]) != 2 || !MazeData.isVisible(this.grid_current_ghostx[j] + x[k3], this.grid_current_ghosty[j] + y[k3])) continue;
                        this.g.fillRect(MazeData.calcGridX(this.grid_current_ghostx[j] + x[k3]) - 1, MazeData.calcGridY(this.grid_current_ghosty[j] + y[k3]) - 1, 2, 2);
                    }
                }
                for (k = 0; k < 4; ++k) {
                    this.ghost_moving[k].resetStatus();
                    this.setGhostMoving();
                }
                for (j = 0; j < 10; ++j) {
                    this.g.setColor(0);
                    this.g.fillRect(real_current_x - this.sprite_w / 2, real_current_y - this.sprite_h / 2, this.sprite_w, this.sprite_h);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    this.SunnetMIDlet.nextFrame();
                    this.g.setColor(0xFFFF00);
                    this.SunnetMIDlet.setPosition(real_current_x - this.sprite_w / 2, real_current_y - this.sprite_h / 2);
                    this.SunnetMIDlet.paint(this.g);
                    this.flushGraphics(0, 0, this.getWidth(), this.getHeight());
                }
                this.continuePlay();
                for (k = 0; k < 5; ++k) {
                    if (grid_current_x <= 0 || grid_current_x >= 29 || MazeData.getData(grid_current_x + x[k], grid_current_y + y[k]) != 2 || !MazeData.isVisible(grid_current_x + x[k], grid_current_y + y[k])) continue;
                    this.g.fillRect(MazeData.calcGridX(grid_current_x + x[k]) - 1, MazeData.calcGridY(grid_current_y + y[k]) - 1, 2, 2);
                }
                this.resetPacmanStatus();
            }
            this.clearCurrent(this.g);
            this.moveOnestep();
            this.draw_magicdot(1, 3);
            this.draw_magicdot(1, 26);
            this.draw_magicdot(28, 3);
            this.draw_magicdot(28, 26);
            for (i = 0; i < 4; ++i) {
                this.ghost_moving[i].ghost_moveOneStep();
            }
            this.setGhostMoving();
            this.drawCurrent(this.g);
            this.g.setColor(0xFFFF00);
            if (time_visible == 500) {
                extraFood_visible = true;
                time_visible = 1;
            }
            if (this.dotEatenCount > MazeData.DOT_TOTAL - 1) {
                ++this.level;
                this.extraFood.nextFrame();
                this.g.setColor(0);
                this.g.fillRect(0, 0, this.w, this.h);
                this.g.setColor(0xFFFF00);
                if (this.level == 7) {
                    this.g.drawString("Congratulation", this.w / 2, this.h / 2 - this.font.getHeight(), 65);
                    this.g.drawString("You are the best one!", this.w / 2, this.h / 2 + 3, 65);
                    this.flushGraphics(0, 0, this.w, this.h);
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ex) {
                        ex.printStackTrace();
                    }
                    SunnetFlash.midlet.exitMidlet();
                } else {
                    this.g.drawString("Level: " + this.level, this.w / 2, this.h / 2, 65);
                }
                this.flushGraphics(0, 0, this.w, this.h);
                this.stopPlay();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
                if (this.level == 5) {
                    for (int i3 = 0; i3 < 2; ++i3) {
                        this.ghost_moving[i3].ANIMATION_STEP = 3;
                    }
                } else if (this.level == 6) {
                    for (int i4 = 0; i4 < 4; ++i4) {
                        this.ghost_moving[i4].ANIMATION_STEP = 2;
                    }
                } else {
                    this.ghost_moving[this.level - 1].setLevel(true);
                }
                this.resetState();
            }
            this.flushGraphics(0, 0, this.getWidth(), this.getHeight());
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                System.out.println("process is interrupted");
            }
        }
        if (this.player != null) {
            try {
                this.player.stop();
                this.player.deallocate();
                this.player.close();
                this.player = null;
                System.out.println("adf");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void moveOnestep() {
        if (this.currentImage == 0) {
            this.handleKeyboardInput();
        }
        if (this.state == 1) {
            if (this.x_direction != 0) {
                this.moveHorizontallY();
            }
            if (this.y_direction != 0) {
                this.moveVertically();
            }
            if (this.currentImage < ANIMATION_STEP - 1) {
                ++this.currentImage;
            } else {
                this.currentImage = 0;
                this.updateScore();
            }
        }
    }

    public void moveHorizontallY() {
        ++this.moveCounter;
        if (this.moveCounter < ANIMATION_STEP) {
            real_current_x += this.x_direction * MOVE_SPEED_X;
        } else {
            this.moveCounter = 0;
            real_current_x = MazeData.calcGridX(grid_current_x += this.x_direction);
            int nextX = this.x_direction + grid_current_x;
            if (grid_current_y == 14 && (nextX <= 1 || nextX >= 28)) {
                if (nextX < -1 && this.x_direction < 0) {
                    grid_current_x = 29;
                    real_current_x = MazeData.calcGridX(grid_current_x);
                } else if (nextX > 30 && this.x_direction > 0) {
                    grid_current_x = 0;
                    real_current_x = MazeData.calcGridX(grid_current_x);
                }
            } else if (MazeData.getData(nextX, grid_current_y) == 1) {
                this.state = 0;
            }
        }
    }

    public void moveVertically() {
        ++this.moveCounter;
        if (this.moveCounter < ANIMATION_STEP) {
            real_current_y += this.y_direction * MOVE_SPEED_Y;
        } else {
            this.moveCounter = 0;
            real_current_y = MazeData.calcGridY(grid_current_y += this.y_direction);
            int nextY = this.y_direction + grid_current_y;
            if (MazeData.getData(grid_current_x, nextY) == 1) {
                this.state = 0;
            }
        }
    }

    public void moveRight() {
        if (this.currentDirection == 2) {
            return;
        }
        int nextX = grid_current_x + 1;
        if (nextX >= 29) {
            return;
        }
        if (MazeData.getData(nextX, grid_current_y) == 1) {
            return;
        }
        this.SunnetMIDlet.setFrameSequence(this.pacmanDesign.Pacmanseq002);
        this.x_direction = 1;
        this.y_direction = 0;
        this.keyboardBuffer = -1;
        this.currentDirection = 2;
        this.state = 1;
    }

    public void moveLeft() {
        if (this.currentDirection == 0) {
            return;
        }
        int nextX = grid_current_x - 1;
        if (nextX <= 1) {
            return;
        }
        if (MazeData.getData(nextX, grid_current_y) == 1) {
            return;
        }
        this.SunnetMIDlet.setFrameSequence(this.pacmanDesign.Pacmanseq001);
        this.x_direction = -1;
        this.y_direction = 0;
        this.keyboardBuffer = -1;
        this.currentDirection = 0;
        this.state = 1;
    }

    public void moveUp() {
        if (this.currentDirection == 1) {
            return;
        }
        int nextY = grid_current_y - 1;
        if (nextY <= 1) {
            return;
        }
        if (MazeData.getData(grid_current_x, nextY) == 1) {
            return;
        }
        this.SunnetMIDlet.setFrameSequence(this.pacmanDesign.Pacmanseq003);
        this.x_direction = 0;
        this.y_direction = -1;
        this.keyboardBuffer = -1;
        this.currentDirection = 1;
        this.state = 1;
    }

    public void moveDown() {
        if (this.currentDirection == 3) {
            return;
        }
        int nextY = grid_current_y + 1;
        if (nextY >= 29) {
            return;
        }
        if (MazeData.getData(grid_current_x, nextY) == 1) {
            return;
        }
        this.SunnetMIDlet.setFrameSequence(this.pacmanDesign.Pacmanseq004);
        this.x_direction = 0;
        this.y_direction = 1;
        this.keyboardBuffer = -1;
        this.currentDirection = 3;
        this.state = 1;
    }

    public void handleKeyboardInput() {
        if (this.keyboardBuffer < 0) {
            return;
        }
        if (this.keyboardBuffer == 0) {
            this.moveLeft();
        } else if (this.keyboardBuffer == 2) {
            this.moveRight();
        } else if (this.keyboardBuffer == 1) {
            this.moveUp();
        } else if (this.keyboardBuffer == 3) {
            this.moveDown();
        }
    }

    public void setKeyboardBuffer(int k) {
        this.keyboardBuffer = k;
    }

    public void updateScore() {
        if ((grid_current_y != 14 || grid_current_x > 0 && grid_current_x < 29) && MazeData.getData(grid_current_x, grid_current_y) != 0 && MazeData.isVisible(grid_current_x, grid_current_y)) {
            this.score += 10;
            MazeData.setVisible(grid_current_x, grid_current_y, false);
            ++this.dotEatenCount;
        }
    }

    public void draw_magicdot(int x, int y) {
        if (!MazeData.isVisible(x, y)) {
            return;
        }
        this.g.setColor(0xFFFF00);
        this.g.fillArc(MazeData.calcGridX(x) - this.magic_dot_radius / 2, MazeData.calcGridY(y) - this.magic_dot_radius / 2, this.magic_dot_radius, this.magic_dot_radius, 0, 360);
    }

    public void WallRectangle(int x1, int y1, int x2, int y2, Graphics g) {
        int x = MazeData.calcGridX(x1);
        int y = MazeData.calcGridY(y1);
        int width = MazeData.calcGridX(x2) - MazeData.calcGridX(x1);
        int height = MazeData.calcGridY(y2) - MazeData.calcGridY(y1);
        g.setColor(153);
        g.drawRoundRect(x, y, width, height, 8, 8);
    }

    public void WallRoundRect(int x1, int y1, int x2, int y2, Graphics g) {
        int x = MazeData.calcGridX(x1);
        int y = MazeData.calcGridY(y1);
        int width = MazeData.calcGridX(x2) - MazeData.calcGridX(x1);
        int height = MazeData.calcGridY(y2) - MazeData.calcGridY(y1);
        g.setColor(0);
        g.fillRoundRect(x + 1, y + 1, width - 1, height - 1, 8, 8);
    }

    public void draw_line(int x1, int y1, int x2, int y2, Graphics g) {
        int x_1 = MazeData.calcGridX(x1);
        int y_1 = MazeData.calcGridY(y1);
        int x_2 = MazeData.calcGridX(x2);
        int y_2 = MazeData.calcGridY(y2);
        g.drawLine(x_1, y_1, x_2, y_2);
    }

    public void drawDot(int x, int y, int dotType, Graphics g) {
        g.setColor(-256);
        if (dotType == 2) {
            g.fillRect(x - 1, y - 1, 2, 2);
        } else {
            g.fillArc(x - this.magic_dot_radius / 2, y - this.magic_dot_radius / 2, this.magic_dot_radius, this.magic_dot_radius, 0, 360);
        }
    }

    public void putDotHorizontally(int x1, int x2, int y, Graphics g) {
        for (int x = x1; x <= x2; ++x) {
            if (MazeData.getData(x, y) != 0) continue;
            int dotType = !(x != 28 && x != 1 || y != 3 && y != 26) ? 3 : 2;
            MazeData.setData(x, y, dotType);
            if (!MazeData.isVisible(x, y)) continue;
            this.drawDot(MazeData.calcGridX(x), MazeData.calcGridY(y), dotType, g);
        }
    }

    public void putDotVertically(int x, int y1, int y2, Graphics g) {
        for (int y = y1; y <= y2; ++y) {
            if (MazeData.getData(x, y) != 0) continue;
            int dotType = !(x != 28 && x != 1 || y != 3 && y != 26) ? 3 : 2;
            MazeData.setData(x, y, dotType);
            if (!MazeData.isVisible(x, y)) continue;
            this.drawDot(MazeData.calcGridX(x), MazeData.calcGridY(y), dotType, g);
        }
    }

    public void keyPressed(int keyCode) {
        System.out.println(keyCode);
        int instantkeyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        if (instantkeyCode == -202) {
            this.stopPlay();
            this.isgameOver = true;
            this.notStopRun = false;
            this.sorry_quitgamepls = true;
            SunnetFlash.maze = null;
            SunnetFlash.menuCanvas.level = this.level < 5 ? this.level : 4;
            SunnetFlash.menuCanvas.Update();
            System.out.println("Back press");
            SunnetFlash.midlet.getDisplay().setCurrent((Displayable)SunnetFlash.menuCanvas);
            Runtime.getRuntime().gc();
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SunnetFlash.midlet.upScore(null, this.score);
        }
    }

    public void setData() {
        MazeData.setBlockMazeData(29, 0, 29, 13);
        MazeData.setBlockMazeData(29, 15, 29, 29);
        MazeData.setBlockMazeData(0, 15, 0, 29);
        MazeData.setBlockMazeData(0, 0, 0, 13);
        MazeData.setBlockMazeData(0, 29, 29, 29);
        MazeData.setBlockMazeData(0, 0, 29, 0);
        MazeData.setBlockMazeData(2, 2, 5, 4);
        MazeData.setBlockMazeData(7, 2, 12, 4);
        MazeData.setBlockMazeData(14, 0, 15, 4);
        MazeData.setBlockMazeData(17, 2, 22, 4);
        MazeData.setBlockMazeData(24, 2, 27, 4);
        MazeData.setBlockMazeData(2, 6, 5, 7);
        MazeData.setBlockMazeData(7, 6, 8, 13);
        MazeData.setBlockMazeData(8, 9, 12, 10);
        MazeData.setBlockMazeData(10, 6, 19, 7);
        MazeData.setBlockMazeData(14, 7, 15, 10);
        MazeData.setBlockMazeData(17, 9, 21, 10);
        MazeData.setBlockMazeData(21, 6, 22, 13);
        MazeData.setBlockMazeData(24, 6, 27, 7);
        MazeData.setBlockMazeData(0, 9, 5, 13);
        MazeData.setBlockMazeData(24, 9, 29, 13);
        MazeData.setBlockMazeData(0, 15, 5, 17);
        MazeData.setBlockMazeData(10, 12, 19, 17);
        MazeData.setBlockMazeData(24, 15, 29, 17);
        MazeData.setBlockMazeData(2, 19, 5, 20);
        MazeData.setBlockMazeData(4, 19, 5, 23);
        MazeData.setBlockMazeData(7, 15, 8, 23);
        MazeData.setBlockMazeData(8, 19, 12, 20);
        MazeData.setBlockMazeData(17, 19, 21, 20);
        MazeData.setBlockMazeData(21, 15, 22, 23);
        MazeData.setBlockMazeData(24, 19, 25, 23);
        MazeData.setBlockMazeData(24, 19, 27, 20);
        MazeData.setBlockMazeData(0, 22, 2, 23);
        MazeData.setBlockMazeData(10, 22, 19, 23);
        MazeData.setBlockMazeData(14, 19, 15, 27);
        MazeData.setBlockMazeData(27, 22, 29, 23);
        MazeData.setBlockMazeData(2, 25, 5, 27);
        MazeData.setBlockMazeData(7, 25, 12, 27);
        MazeData.setBlockMazeData(17, 25, 22, 27);
        MazeData.setBlockMazeData(24, 25, 27, 27);
        this.SetDotHorizontally(2, 13, 1);
        this.SetDotHorizontally(16, 27, 1);
        this.SetDotHorizontally(2, 27, 5);
        this.SetDotHorizontally(2, 27, 28);
        this.SetDotHorizontally(2, 13, 24);
        this.SetDotHorizontally(16, 27, 24);
        this.SetDotHorizontally(2, 5, 8);
        this.SetDotHorizontally(9, 13, 8);
        this.SetDotHorizontally(16, 20, 8);
        this.SetDotHorizontally(24, 27, 8);
        this.SetDotHorizontally(2, 5, 18);
        this.SetDotHorizontally(9, 13, 21);
        this.SetDotHorizontally(16, 20, 21);
        this.SetDotHorizontally(24, 27, 18);
        this.SetDotHorizontally(2, 3, 21);
        this.SetDotHorizontally(26, 27, 21);
        this.SetDotVertically(1, 1, 8);
        this.SetDotVertically(1, 18, 21);
        this.SetDotVertically(1, 24, 28);
        this.SetDotVertically(28, 1, 8);
        this.SetDotVertically(28, 18, 21);
        this.SetDotVertically(28, 24, 28);
        this.SetDotVertically(6, 2, 27);
        this.SetDotVertically(23, 2, 27);
        this.SetDotVertically(3, 22, 23);
        this.SetDotVertically(9, 22, 23);
        this.SetDotVertically(20, 22, 23);
        this.SetDotVertically(26, 22, 23);
        this.SetDotVertically(13, 25, 27);
        this.SetDotVertically(16, 25, 27);
        this.SetDotVertically(9, 6, 7);
        this.SetDotVertically(20, 6, 7);
        this.SetDotVertically(13, 2, 4);
        this.SetDotVertically(16, 2, 4);
    }

    public void SetDotVertically(int x, int y1, int y2) {
        for (int y = y1; y <= y2; ++y) {
            MazeData.setVisible(x, y, true);
        }
    }

    public void SetDotHorizontally(int x1, int x2, int y) {
        for (int x = x1; x <= x2; ++x) {
            MazeData.setVisible(x, y, true);
        }
    }

    public void setGhostMoving() {
        for (int i = 0; i < 4; ++i) {
            this.grid_current_ghostx[i] = this.ghost_moving[i].getGrid_current_ghosx();
            this.grid_current_ghosty[i] = this.ghost_moving[i].getGrid_current_ghosy();
            this.real_current_ghostx[i] = this.ghost_moving[i].getReal_current_ghosx();
            this.real_current_ghosty[i] = this.ghost_moving[i].getReal_current_ghosy();
        }
    }

    public void setGhost() {
        for (int i = 0; i < 4; ++i) {
            this.ghost[i].setFrameSequence(this.pacmanDesign.Pacmanseq00[i]);
        }
    }

    public void setHollow() {
        for (int i = 0; i < 4; ++i) {
            Maze.isHollow[i] = true;
            this.ghost[i].setFrameSequence(this.pacmanDesign.Pacmanseq009);
            ++this.ghost_moving[i].ANIMATION_STEP;
        }
    }

    public boolean isEatMagicDot() {
        if (real_current_x == MazeData.calcGridX(1) && real_current_y == MazeData.calcGridY(3)) {
            if (this.eatMagic[0]) {
                return false;
            }
            this.eatMagic[0] = true;
            return true;
        }
        if (real_current_x == MazeData.calcGridX(1) && real_current_y == MazeData.calcGridY(26)) {
            if (this.eatMagic[1]) {
                return false;
            }
            this.eatMagic[1] = true;
            return true;
        }
        if (real_current_x == MazeData.calcGridX(28) && real_current_y == MazeData.calcGridY(3)) {
            if (this.eatMagic[2]) {
                return false;
            }
            this.eatMagic[2] = true;
            return true;
        }
        if (real_current_x == MazeData.calcGridX(28) && real_current_y == MazeData.calcGridY(26)) {
            if (this.eatMagic[3]) {
                return false;
            }
            this.eatMagic[3] = true;
            return true;
        }
        return false;
    }

    public boolean Met(int i) {
        int ImageX = 0;
        int ImageY = 0;
        ImageX = this.real_current_ghostx[i];
        ImageY = this.real_current_ghosty[i];
        int distanceX = Math.abs(ImageX - real_current_x);
        int distanceY = Math.abs(ImageY - real_current_y);
        if (distanceX > this.distanceThreshold) {
            return false;
        }
        if (distanceY > this.distanceThreshold) {
            return false;
        }
        return distanceX * distanceX + distanceY * distanceY <= this.distanceThreshold * this.distanceThreshold;
    }

    public void pacmanEateGhost(Graphics g) {
        int n = 200;
        ++this.ghostEatenCount;
        for (int i = 1; i < this.ghostEatenCount; ++i) {
            n *= 2;
        }
        this.score += n;
        g.setColor(0xFFFF00);
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        if (n == 1600) {
            g.drawString("1", MazeData.calcGridX(29) + 4, MazeData.calcGridY(13) - 8 - 3 * this.font.getHeight(), 68);
            g.drawString("6", MazeData.calcGridX(29) + 4, MazeData.calcGridY(13) - 6 - 2 * this.font.getHeight(), 68);
        } else {
            g.drawString("" + n / 100, MazeData.calcGridX(29) + 4, MazeData.calcGridY(13) - 4 - 2 * this.font.getHeight(), 68);
        }
        g.drawString("0", MazeData.calcGridX(29) + 4, MazeData.calcGridY(13) - 4 - this.font.getHeight(), 68);
        g.drawString("0", MazeData.calcGridX(29) + 4, MazeData.calcGridY(13) - 2, 68);
        g.setFont(Font.getFont((int)0, (int)0, (int)0));
    }

    public void resetState() {
        MazeData.resetData();
        for (int i = 0; i < 4; ++i) {
            this.ghost_moving[i].resetStatus();
            this.eatMagic[i] = false;
        }
        this.setGhostMoving();
        this.resetPacmanStatus();
        this.setGhost();
        this.setData();
        this.draw_Maze(this.g);
        this.dotEatenCount = 0;
    }

    public void destroy() {
        this.t.interrupt();
        this.notStopRun = false;
        if (this.player != null) {
            try {
                this.player.stop();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
            this.player.close();
            this.player = null;
        }
    }

    static {
        ANIMATION_STEP = 4;
        isHollow = new boolean[]{false, false, false, false};
    }
}

