/*
 * Decompiled with CFR 0.152.
 */
public class MazeData {
    private int h;
    private int w;
    public static final int GRID_SIZE = 29;
    public static final int EMPTY = 0;
    public static final int BLOCK = 1;
    public static final int NORMAL_DOT = 2;
    public static final int MAGIC_DOT = 3;
    public static int DOT_TOTAL = 246;
    public static int[][] mazeData = new int[30][30];
    public static boolean[][] Dot_visible = new boolean[30][30];
    public static int GRID_GAP_X;
    public static int GRID_GAP_Y;
    public static final int GRID_STROKE = 2;
    public static int xoffset;
    public static int yoffset;

    public MazeData(int w, int h) {
        this.w = w;
        this.h = h;
        GRID_GAP_X = w / 31;
        GRID_GAP_Y = h / 36;
        xoffset = GRID_GAP_X;
        yoffset = GRID_GAP_Y;
    }

    public static int makeInRange(int a) {
        if (a < 0) {
            a = 0;
        } else if (a > 29) {
            a = 29;
        }
        return a;
    }

    public static void setBlockMazeData(int x1, int y1, int x2, int y2) {
        int i;
        x1 = MazeData.makeInRange(x1);
        x2 = MazeData.makeInRange(x2);
        y1 = MazeData.makeInRange(y1);
        y2 = MazeData.makeInRange(y2);
        for (i = x1; i <= x2; ++i) {
            MazeData.mazeData[i][y1] = 1;
            MazeData.mazeData[i][y2] = 1;
        }
        for (i = y1; i <= y2; ++i) {
            MazeData.mazeData[x1][i] = 1;
            MazeData.mazeData[x2][i] = 1;
        }
    }

    public static int calcGridX(int x) {
        return GRID_GAP_X * x + xoffset;
    }

    public static int calcGridY(int y) {
        return GRID_GAP_Y * y + yoffset;
    }

    public static int getData(int x, int y) {
        return mazeData[x][y];
    }

    public static void setData(int x, int y, int value) {
        MazeData.mazeData[x][y] = value;
    }

    public static boolean isVisible(int x, int y) {
        return Dot_visible[x][y];
    }

    public static void setVisible(int x, int y, boolean visible) {
        MazeData.Dot_visible[x][y] = visible;
    }

    public static void resetData() {
        for (int i = 0; i < 30; ++i) {
            for (int j = 0; j < 30; ++j) {
                MazeData.mazeData[i][j] = 0;
                MazeData.Dot_visible[i][j] = true;
            }
        }
    }
}

